class ZoomShockRifle expands SuperShockRifle;

#exec TEXTURE IMPORT NAME=Reticle FILE=TEXTURES\scope.bmp GROUP="Skin" MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=skin0 FILE=TEXTURES\skin0.bmp GROUP="Skin" MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=skin1 FILE=TEXTURES\skin1.bmp GROUP="Skin" MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=skin2 FILE=TEXTURES\skin2.bmp GROUP="Skin" MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=skin3 FILE=TEXTURES\skin3.bmp GROUP="Skin" MIPS=OFF FLAGS=2 LODSET=2

var int NumFire;
var vector OwnerLocation;
var float StillTime, StillStart;
var bool bZoom;

simulated function PostRender( canvas Canvas )        /// zoom canvas
{
	local PlayerPawn P;
	local float Scale;
	local float Xlength;
	local float range;
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local float radpitch;
	local actor Other;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
	{
		bOwnsCrossHair = true;

		////////Cross hair lens
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		Canvas.Style = ERenderStyle.STY_Translucent;

		Canvas.DrawColor = 15*ChallengeHUD(PlayerPawn(Owner).myhud).CrosshairColor; //?
		Canvas.DrawIcon(Texture'Reticle', Scale);
		/// dots
		Canvas.Style = ERenderStyle.STY_Normal;

		Scale = P.DefaultFOV/P.DesiredFOV;

			// Calc range
        		XLength=255.0;
			GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
			if ((Pawn(Owner).ViewRotation.Pitch >= 0) && (Pawn(Owner).ViewRotation.Pitch <= 18000))
				radpitch = float(Pawn(Owner).ViewRotation.Pitch) / float(182) * (Pi/float(180));
			else
				radpitch = float(Pawn(Owner).ViewRotation.Pitch - 65535) / float(182) * (Pi/float(180));

			StartTrace = Owner.Location + Pawn(Owner).EyeHeight*Z*cos(radpitch);
	    		AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);
			EndTrace = StartTrace +(20000 * vector(AdjustedAim));
			Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
			range = Vsize(StartTrace-HitLocation)/48-0.25;

			// Magnification Display
			Canvas.SetPos( Canvas.ClipX * 0.5 + 256, Canvas.ClipY * 0.5 - 16 );
			Canvas.Font = Font'Botpack.WhiteFont';
			Canvas.DrawColor.R = 0;
			Canvas.DrawColor.G = 255;
			Canvas.DrawColor.B = 0;
			Scale = P.DefaultFOV/P.DesiredFOV;
			Canvas.DrawText("zoom: "$int(Scale));

			// Range Display
			Canvas.SetPos( Canvas.ClipX * 0.5 + 256, Canvas.ClipY * 0.5 );
			Canvas.Font = Font'Botpack.WhiteFont';
			Canvas.DrawColor.R = 0;
			Canvas.DrawColor.G = 255;
			Canvas.DrawColor.B = 0;
	       	 	Canvas.DrawText( "range: "$int(range));

	}

	else
	{
		bOwnsCrossHair = false;


	}
}

simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	
	ClientAltFire(Value);
}

state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
Begin:
	FlashCount++;
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 1.00;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		//if ( bGotRapidFire )
		//	{
		//	SetTimer(0.1, false);
		//	}
		//else
			SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	SpawnEffect(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(1000, Pawn(Owner), HitLocation, 35000 * X, 'Decapitated');
		else if ( Other.bIsPawn )
			Other.TakeDamage(1000,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);
		else	
			Spawn(class'ut_SuperRing2',,, HitLocation+HitNormal,rotator(HitNormal));
	}
}

function SpawnEffect(vector HitLocation, vector SmokeLocation)
{
	local ShockBeam Smoke,shock;
	local Vector DVector;
	local int NumPoints;
	local rotator SmokeRotation;

	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/135.0;
	if ( NumPoints < 1 )
		return;
	SmokeRotation = rotator(DVector);
	SmokeRotation.roll = Rand(65535);
	
	Smoke = Spawn(class'ShockBeam',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints - 1;	
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);	
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 100000 * X; 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

state Idle
{
	function Fire( float Value )
	{
	
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			TraceFire(0.0);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	AmmoType.AmmoAmount = 100; //Reset ammo count back to the max
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			bZoom = false;
			SetTimer(0.0,False);
			GoToState('Idle');
		}
		else if ( bZoom )
		{
			if ( PlayerPawn(Owner).DesiredFOV > 1 )
			{
				PlayerPawn(Owner).DesiredFOV -= PlayerPawn(Owner).DesiredFOV*DeltaTime*4.5;
			}

			if ( PlayerPawn(Owner).DesiredFOV <=1 )
			{
				PlayerPawn(Owner).DesiredFOV = 1;
				//bZoom = false;
				SetTimer(0.0,False);
				GoToState('Idle');
			}
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV )
			{
				bZoom = true;
				SetTimer(0.2,True);
			}
			else if ( bZoom == false )
			{
				PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
				Pawn(Owner).bAltFire = 0;
			}
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

simulated function PlayFiring()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*4.0);
	LoopAnim('Fire1', 0.30 + 0.30 * FireAdjust,0.05);
}

defaultproperties
{
PickupAmmoCount=100
DeathMessage="%k gibbed %o with the %w."
PickupMessage="You got the UT InstaGib Rifle."
ItemName="UT InstaGib Rifle"
FireSound=Sound'UnrealShare.ASMD.TazerFire'
MultiSkins(0)=Texture'skin0'
MultiSkins(1)=Texture'skin1'
MultiSkins(2)=Texture'skin2'
MultiSkins(3)=Texture'skin3'
}
